import React from 'react'
import { styles } from './reCaptchaStyle'
import { AntDesign } from "@expo/vector-icons";
import { MaterialCommunityIcons } from "@expo/vector-icons";
import { View, ActivityIndicator as RNActivityIndicator } from 'react-native'

const ActivityIndicator = ({reCaptchaToken, loading}) => {
  return (
    <View style={styles.checkbox}>
        {
            !reCaptchaToken && loading && (
                <RNActivityIndicator size="small" color="#508ef5" />
            )
        }
        {
            reCaptchaToken && !loading && (
                <AntDesign name="check" size={24} color="#009e55" />
            )
        }
        {
            !reCaptchaToken && !loading && (
                <MaterialCommunityIcons
                    name="checkbox-blank-outline"
                    size={24}
                    color="#b2b2b2"
                />
            )
        }
    </View>
  )
}

export default ActivityIndicator